<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package OSC GiftWrap Hyva Compatibility by Amasty
 */

namespace Amasty\CheckoutGiftWrapHyvaCompatibility\ViewModel;

use Magento\Framework\DataObject;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\GiftMessage\Helper\Message as MessageHelper;
use Magento\GiftMessage\Model\Message as MessageModel;

/**
 * Wrapper class for helper
 */
class Message implements ArgumentInterface
{
    /**
     * @var MessageHelper
     */
    private $messageHelper;

    /**
     * @param MessageHelper $messageHelper
     */
    public function __construct(
        MessageHelper $messageHelper
    ) {
        $this->messageHelper = $messageHelper;
    }

    /**
     * Wrapper for isMessageAllowed method of helper
     *
     * @param string $type
     * @param DataObject $entity
     * @return boolean
     */
    public function isMessagesAllowed(string $type, DataObject $entity): bool
    {
        return (bool)$this->messageHelper->isMessagesAllowed($type, $entity);
    }

    /**
     * Wrapper for getGiftMessageForEntity method of helper
     *
     * @param DataObject $entity
     * @return MessageModel|null
     */
    public function getGiftMessageForEntity(DataObject $entity): ?MessageModel
    {
        return $this->messageHelper->getGiftMessageForEntity($entity);
    }

    /**
     * Wrapper for getEscapedGiftMessage method of helper
     *
     * @param DataObject $entity
     * @return string|null
     */
    public function getEscapedGiftMessage(DataObject $entity): ?string
    {
        return $this->messageHelper->getEscapedGiftMessage($entity);
    }
}
