define(
    [
        'ko',
        'jquery',
        'uiComponent',
        'Magento_Checkout/js/model/quote'
    ],
    function (ko, $, Component, quote) {
        'use strict';
        var checkoutConfig = window.checkoutConfig,
            CcpaConfig = checkoutConfig ? checkoutConfig.amastyCcpaConsent : {};

        return Component.extend({
            defaults: {
                template: 'Amasty_Ccpa/checkout/ccpa-consent'
            },

            isEnabled: CcpaConfig.length  !== 0,

            items: CcpaConfig['consents'],

            metaInfo: CcpaConfig['meta'],
            uniqId: null,

            getUniqId: function () {
                if (this.uniqId === null) {
                    this.uniqId = Math.round(Math.random() * 10000);

                    return this.uniqId;
                }
                var returnId = this.uniqId;
                this.uniqId = null;

                return returnId;
            },


            initialize: function () {
                this._super();
                this.items = this.items || [];
                this.items.forEach(function (item) {
                    item.checked = ko.observable(false);
                });

                quote.billingAddress.subscribe(function (billingAddress) {
                    if (!billingAddress) {
                        return;
                    }

                    var country = billingAddress.countryId;

                    if (!country) {
                        return;
                    }

                    this.items.forEach(function (item) {
                        const countries = item['county_codes'] || [];
                        item['visible'] = countries.length ? countries.indexOf(country) !== -1 : true;
                    });
                }.bind(this));

                return this;
            },

            getWhere: function () {
              return this.metaInfo['where'];
            },

            initModal: function (element) {
                var self = this;
                $(element).find('a[href="#"]').on('mouseup', function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    $.ajax({
                        async: false,
                        url: CcpaConfig.meta.privacyUrl,
                        success: function (data) {
                            $('#amccpa-privacy-popup').html(data);
                        }
                    });
                    $('#amccpa-privacy-popup').modal('openModal').on('modalclosed', function () {
                        $('#amccpa-privacy-popup').html('');
                    });
                    $('#amccpa-privacy-popup').data(
                        'amccpa-checkbox-selector',
                        '.payment-method._active #' + $(this).closest('.amasty-ccpa-consent').find('input[type="checkbox"]').attr('id')
                    );
                })
            }
        });
    }
);
