define([
    'jquery'
], function ($) {
    'use strict';

    return function (paymentData) {
        var consents = checkoutConfig.amastyCcpaConsent.consents || [];
        var consentData = {};

        _.each(consents, function (consent) {
            var consentElement = $('input[data-ccpa-checkbox-code="' + consent.checkbox_code + '"]:visible');

            if (consentElement) {
                consentData[consent.checkbox_code] = Boolean(consentElement.prop('checked'));
            }
        });

        if (!paymentData['additional_data']) {
            paymentData['additional_data'] = {};
        }

        paymentData['additional_data']['amccpa_agreement'] = JSON.stringify(consentData);
    };
});
