define(
    [
        'jquery',
        'mage/validation'
    ],
    function ($) {
        'use strict';
        var checkoutConfig = window.checkoutConfig,
            CcpaConfig = checkoutConfig ? checkoutConfig.amastyCcpaConsent : {};

        return {
            consentInputPath: 'div.amasty-ccpa-consent:visible input',

            /**
             * Validate checkout agreements
             *
             * @param {boolean} hideError
             * @returns {boolean}
             */
            validate: function (hideError) {
                var isValid = true,
                    isValidSingleElement,
                    consentInput;

                consentInput = $(this.consentInputPath);

                if (!consentInput.length) {
                    return true;
                }

                consentInput.each(function (i, element) {
                    isValidSingleElement = $.validator.validateSingleElement(element, {
                        errorElement: 'div',
                        errorClass: 'mage-error',
                        meta: 'validate',
                        hideError: Boolean(hideError),
                        errorPlacement: function (error, element) {
                            element.siblings('label').last().after(error);
                        }
                    })
                    if (!isValidSingleElement) {
                        isValid = false;
                    }
                });

                return isValid;
            }
        };
    }
);
