<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Ui\DataProvider\Listing;

use Amasty\Ccpa\Api\WithConsentRepositoryInterface;
use Amasty\Ccpa\Model\ResourceModel\WithConsent\Collection;
use Magento\Framework\View\Element\UiComponent\DataProvider\DataProviderInterface;
use Magento\Ui\DataProvider\AbstractDataProvider;

class WithConsentDataProvider extends AbstractDataProvider implements DataProviderInterface
{
    /**
     * @var WithConsentRepositoryInterface
     */
    private $repository;

    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        Collection $collection,
        WithConsentRepositoryInterface $repository,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $collection;
        $this->repository = $repository;

        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * @return array|mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getData()
    {
        $data = parent::getData();

        return $data;
    }
}
