<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Setup;

use Amasty\Ccpa\Model\Consent\ConsentStore\ResourceModel\ConsentStore;
use Amasty\Ccpa\Model\Consent\ResourceModel\Consent;
use Amasty\Ccpa\Model\ResourceModel\ActionLog;
use Amasty\Ccpa\Model\ResourceModel\ConsentQueue;
use Amasty\Ccpa\Model\ResourceModel\DeleteRequest;
use Amasty\Ccpa\Model\ResourceModel\Policy;
use Amasty\Ccpa\Model\ResourceModel\PolicyContent;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $this
            ->uninstallTables($setup)
            ->uninstallConfigData($setup);
        $setup->endSetup();
    }

    private function uninstallTables(SchemaSetupInterface $setup): self
    {
        $tablesToDrop = [
            Policy::TABLE_NAME,
            DeleteRequest::TABLE_NAME,
            Policy::TABLE_NAME,
            PolicyContent::TABLE_NAME,
            ActionLog::TABLE_NAME,
            ConsentStore::TABLE_NAME,
            ConsentQueue::TABLE_NAME,
            Consent::TABLE_NAME
        ];
        foreach ($tablesToDrop as $table) {
            $setup->getConnection()->dropTable(
                $setup->getTable($table)
            );
        }
        
        return $this;
    }

    private function uninstallConfigData(SchemaSetupInterface $setup): self
    {
        $configTable = $setup->getTable('core_config_data');
        $setup->getConnection()->delete($configTable, "`path` LIKE 'amasty_ccpa%'");

        return $this;
    }
}
