<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Setup\Patch\Data;

use Magento\Customer\Model\Customer;
use Magento\Customer\Setup\CustomerSetupFactory;
use Magento\Framework\Module\ResourceInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class UpgradeTo120 implements DataPatchInterface
{
    /**
     * @var CustomerSetupFactory
     */
    private $customerSetupFactory;

    /**
     * @var ResourceInterface
     */
    private $moduleResource;

    public function __construct(
        CustomerSetupFactory $customerSetupFactory,
        ResourceInterface $moduleResource
    ) {
        $this->customerSetupFactory = $customerSetupFactory;
        $this->moduleResource = $moduleResource;
    }

    public function apply()
    {
        $setupDataVersion = $this->moduleResource->getDataVersion('Amasty_Ccpa');

        if ($setupDataVersion && version_compare($setupDataVersion, '1.2.0', '<')) {
            $this->upgradeAttribute();
        }
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }

    public function upgradeAttribute()
    {
        /** @var \Magento\Customer\Setup\CustomerSetup $customerSetup */
        $customerSetup = $this->customerSetupFactory->create();

        $attribute = $customerSetup->getEavConfig()->getAttribute(
            Customer::ENTITY,
            InstallSampleData::ALLOW_OPT_OUT_CUSTOMER_ATTRIBUTE
        )->addData(
            [
                'used_in_forms' => ['adminhtml_customer']
            ]
        );

        $attribute->save();
    }
}
