<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Setup\Patch\Data;

use Magento\Customer\Model\Customer;
use Magento\Customer\Setup\CustomerSetupFactory;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class UpgradeFrontendLabel implements DataPatchInterface
{
    /**
     * @var CustomerSetupFactory
     */
    private $customerSetupFactory;

    public function __construct(
        CustomerSetupFactory $customerSetupFactory
    ) {
        $this->customerSetupFactory = $customerSetupFactory;
    }

    public static function getDependencies(): array
    {
        return [
            InstallSampleData::class
        ];
    }

    public function getAliases(): array
    {
        return [];
    }

    public function apply(): self
    {
        $customerSetup = $this->customerSetupFactory->create();
        if ($attribute = $customerSetup->getEavConfig()->getAttribute(
            Customer::ENTITY,
            InstallSampleData::ALLOW_OPT_OUT_CUSTOMER_ATTRIBUTE
        )) {
            $attribute->addData(['frontend_label' => 'Don\'t Sell or Share My Personal Information',]);
            $attribute->save();
        }

        return $this;
    }
}
