<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Plugin\WithoutConsent\Grid;

use Amasty\Ccpa\Model\ResourceModel\WithConsent\CollectionFactory;
use Amasty\Ccpa\Model\ResourceModel\WithoutConsent\Grid\Collection as WithoutConsentCollection;

class Collection
{
    /**
     * @var CollectionFactory
     */
    private $withConsentCollectionFactory;

    public function __construct(
        CollectionFactory $withConsentCollectionFactory
    ) {
        $this->withConsentCollectionFactory = $withConsentCollectionFactory;
    }

    /**
     * @param WithoutConsentCollection $subject
     * @param WithoutConsentCollection $result
     *
     * @return mixed
     */
    //phpcs:ignore PSR1.Methods.CamelCapsMethodName.NotCamelCaps
    public function after_initSelect($subject, $result)
    {
        /** @var \Amasty\Ccpa\Model\ResourceModel\WithConsent\Collection $withConsentCollection */
        $withConsentCollection = $this->withConsentCollectionFactory->create();
        $customerIds = $withConsentCollection->getConsentCustomerIds();

        $result->getSelect()->columns(
            [
                'name'        => 'CONCAT_WS(\' \',
                            main_table.prefix,
                            main_table.firstname,
                            main_table.middlename,
                            main_table.lastname,
                            main_table.suffix)',
                'customer_id' => 'entity_id'
            ]
        );

        $result->getSelect()->joinLeft(
            ['customer_address' => $result->getTable('customer_address_entity')],
            'customer_address.parent_id = main_table.default_billing',
            [
                'country_id'
            ]
        );

        if (!empty($customerIds)) {
            $result->addFieldToFilter('main_table.entity_id', ['nin' => $customerIds]);
        }

        $result->getSelect()->group('main_table.entity_id');

        $result->addFilterToMap(
            'entity_id',
            'main_table.entity_id'
        );

        return $result;
    }
}
