<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Plugin\Customer\Model;

use Amasty\Ccpa\Model\CalifornianDetector;
use Amasty\Ccpa\Model\Config;
use Magento\Framework\App\RequestInterface;

class DataProviderAbstract
{
    /**
     * @var CalifornianDetector
     */
    private $californianDetector;

    /**
     * @var Config
     */
    private $config;

    /**
     * @var RequestInterface
     */
    private $request;

    public function __construct(
        CalifornianDetector $californianDetector,
        Config $config,
        RequestInterface $request
    ) {
        $this->californianDetector = $californianDetector;
        $this->config = $config;
        $this->request = $request;
    }

    protected function modifyData(array $data): array
    {
        $customerId = $this->request->getParam('id', null);

        if (!$customerId) {
            return $data;
        }
        $websiteId = $data[$customerId]['customer']['website_id'] ?? null;

        if ($this->config->isOnlyCalifornians($websiteId)) {
            $data[$customerId]['customer']['show_pd_opt'] = $this->californianDetector->isCalifornian((int)$customerId);
        }

        return $data;
    }
}
