<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Plugin\Checkout;

use Amasty\Base\Model\Serializer;
use Amasty\Ccpa\Model\Consent\RegistryConstants;
use Amasty\Ccpa\Model\ConsentLogger;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;

class PaymentInformationPlugin
{
    /**
     * @var Serializer
     */
    private $serializer;

    /**
     * @var ManagerInterface
     */
    private $eventManager;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        Serializer $serializer,
        ManagerInterface $eventManager,
        StoreManagerInterface $storeManager
    ) {
        $this->serializer = $serializer;
        $this->eventManager = $eventManager;
        $this->storeManager = $storeManager;
    }

    /**
     * @param \Magento\Checkout\Api\PaymentInformationManagementInterface $subject
     * @param int $cartId
     * @param \Magento\Quote\Api\Data\PaymentInterface $paymentMethod
     * @param \Magento\Quote\Api\Data\AddressInterface|null $billingAddress
     * @throws NoSuchEntityException
     * @return void
     */
    public function beforeSavePaymentInformation(
        \Magento\Checkout\Api\PaymentInformationManagementInterface $subject,
        $cartId,
        \Magento\Quote\Api\Data\PaymentInterface $paymentMethod,
        \Magento\Quote\Api\Data\AddressInterface $billingAddress = null
    ) {
        $additionalData = $paymentMethod->getAdditionalData();
        if (isset($additionalData[RegistryConstants::CONSENTS])
        ) {
            $this->logConsents($additionalData[RegistryConstants::CONSENTS]);
        }
    }

    /**
     * @param array $codes
     *
     * @throws NoSuchEntityException
     */
    public function logConsents($codes)
    {
        $storeId = (int)$this->storeManager->getStore()->getId();

        if (!empty($codes)) {
            try {
                $codes = $this->serializer->unserialize($codes);
                $this->eventManager->dispatch(
                    'amasty_ccpa_consent_accept',
                    [
                        RegistryConstants::CONSENTS => $codes,
                        RegistryConstants::CONSENT_FROM => ConsentLogger::FROM_CHECKOUT,
                        RegistryConstants::STORE_ID => $storeId
                    ]
                );
            } catch (\Exception $e) {
                return;
            }
        }
    }
}
