<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Observer\Customer;

use Amasty\Ccpa\Model\ActionLogger;
use Amasty\Ccpa\Model\Config\Source\Action as ActionOptions;
use Amasty\Ccpa\Setup\Patch\Data\InstallSampleData;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class AfterSaveDataObject implements ObserverInterface
{
    /**
     * @var ActionLogger
     */
    private $logger;

    public function __construct(ActionLogger $logger)
    {
        $this->logger = $logger;
    }

    public function execute(Observer $observer)
    {
        /** @var CustomerInterface $customer */
        $customer = $observer->getEvent()->getCustomerDataObject();

        /** @var CustomerInterface $customerOrig */
        $customerOrig = $observer->getEvent()->getOrigCustomerDataObject();

        $attributeValue = $this->getAllowOptOut($customer);
        $attributeValueOrig = $this->getAllowOptOut($customerOrig);

        if ($attributeValue !== $attributeValueOrig) {
            $action = $attributeValue
                ? ActionOptions::DENIED_TO_SELL_PERSONAL_INFORMATION
                : ActionOptions::ALLOWED_TO_SELL_PERSONAL_INFORMATION;
            $this->logger->logAction($action, $customer->getId());
        }
    }

    private function getAllowOptOut(?CustomerInterface $customer): bool
    {
        if ($customer
            && ($attribute = $customer->getCustomAttribute(InstallSampleData::ALLOW_OPT_OUT_CUSTOMER_ATTRIBUTE))
        ) {
            return (bool)$attribute->getValue();
        }

        return false;
    }
}
