<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\ResourceModel\WithConsent;

class Collection extends \Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection
{
    /**
     * @SuppressWarnings(PHPMD.CamelCaseMethodName)
     */
    public function _construct()
    {
        parent::_construct();
        $this->_init(
            \Amasty\Ccpa\Model\WithConsent::class,
            \Amasty\Ccpa\Model\ResourceModel\WithConsent::class
        );
        $this->_setIdFieldName($this->getResource()->getIdFieldName());
    }

    public function getConsentCustomerIds()
    {
        //@codingStandardsIgnoreStart
        $this->getSelect()->group('customer_id');
        //@codingStandardsIgnoreStop
        $customerIds = $this->getColumnValues('customer_id');

        return $customerIds;
    }
}
