<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\ResourceModel\Policy;

use Amasty\Ccpa\Model\Policy;
use Amasty\Ccpa\Model\ResourceModel\Policy as PolicyResource;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

/**
 * @method Policy[] getItems()
 */
class Collection extends AbstractCollection
{
    /**
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function _construct()
    {
        $this->_init(Policy::class, PolicyResource::class);
        $this->_setIdFieldName($this->getResource()->getIdFieldName());
    }

    public function joinContent($storeId)
    {
        $this->getSelect()
            ->joinLeft(
                ['c' => $this->getTable('amasty_ccpa_privacy_policy_content')],
                'main_table.id = c.policy_id AND store_id = ' . (int) $storeId,
                ['content' => 'IF(c.id IS NOT NULL, c.content, main_table.content)']
            );

        return $this;
    }
}
