<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\OptionSource\Consent;

use Magento\Framework\Option\ArrayInterface;
use Amasty\Ccpa\Model\ConsentLogger;

class From implements ArrayInterface
{
    public function toOptionArray()
    {
        return [
            ['value' => ConsentLogger::FROM_REGISTRATION, 'label'=> __('Registration')],
            ['value' => ConsentLogger::FROM_CHECKOUT, 'label'=> __('Checkout')],
            ['value' => ConsentLogger::FROM_CONTACTUS, 'label'=> __('Contact Us')],
            ['value' => ConsentLogger::FROM_SUBSCRIPTION, 'label'=> __('Newsletter Subscription')],
            ['value' => ConsentLogger::FROM_EMAIL, 'label'=> __('Email')]
        ];
    }
}
