<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\Cron;

use Amasty\Ccpa\Api\Data\ActionLogInterface;
use Amasty\Ccpa\Model\CleaningDate;
use Amasty\Ccpa\Model\ResourceModel\ActionLog;
use Magento\Framework\App\ResourceConnection;

class ClearLog
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var CleaningDate
     */
    private $cleaningDate;

    public function __construct(
        ResourceConnection $resourceConnection,
        CleaningDate $cleaningDate
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->cleaningDate = $cleaningDate;
    }

    public function clearLog()
    {
        if (!$dateForRemove = $this->cleaningDate->getAutoCleaningDate()) {
            return;
        }
        $tableName = $this->resourceConnection->getTableName(ActionLog::TABLE_NAME);
        $this->resourceConnection->getConnection()->delete(
            $tableName,
            [ActionLogInterface::CREATED_AT . ' < ?' => $dateForRemove]
        );
    }
}
