<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\Cron;

use Amasty\Ccpa\Api\Data\DeleteRequestInterface;
use Amasty\Ccpa\Api\DeleteRequestRepositoryInterface;
use Amasty\Ccpa\Model\Anonymizer;
use Amasty\Ccpa\Model\CleaningDate;
use Amasty\Ccpa\Model\ResourceModel\DeleteRequest\CollectionFactory as DeleteRequestsCollectionFactory;

class AutomaticAnonymizer
{
    /**
     * @var CleaningDate
     */
    private $cleaningDate;

    /**
     * @var DeleteRequestsCollectionFactory
     */
    private $deleteRequestsCollectionFactory;

    /**
     * @var Anonymizer
     */
    private $anonymizer;

    /**
     * @var DeleteRequestRepositoryInterface
     */
    private $deleteRequestRepository;

    public function __construct(
        CleaningDate $cleaningDate,
        DeleteRequestsCollectionFactory $deleteRequestsCollectionFactory,
        Anonymizer $anonymizer,
        DeleteRequestRepositoryInterface $deleteRequestRepository
    ) {
        $this->cleaningDate = $cleaningDate;
        $this->deleteRequestsCollectionFactory = $deleteRequestsCollectionFactory;
        $this->anonymizer = $anonymizer;
        $this->deleteRequestRepository = $deleteRequestRepository;
    }

    public function requestProcess()
    {
        if (!$dateForRemove = $this->cleaningDate->getPersonalDataStoredDate()) {
            return;
        }

        $requestsCollection = $this->deleteRequestsCollectionFactory->create();
        $requestsCollection->addFieldToSelect(DeleteRequestInterface::CUSTOMER_ID);
        $requestsCollection->addFieldToFilter(
            DeleteRequestInterface::APPROVED,
            ['eq' => \Amasty\Ccpa\Model\DeleteRequest::IS_APPROVED]
        );

        foreach ($requestsCollection as $request) {
            $this->anonymizer->deleteExpiredItems($request->getCustomerId());
        }
    }
}
