<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\ConsentQueue;

use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\UrlInterface;

class Notification
{
    /**
     * @var ManagerInterface
     */
    private $messageManager;

    /**
     * @var UrlInterface
     */
    private $url;

    public function __construct(
        ManagerInterface $messageManager,
        UrlInterface $url
    ) {
        $this->messageManager = $messageManager;
        $this->url = $url;
    }

    /**
     * Add notice message with link to email queue grid
     */
    public function addQueueLinkNotice()
    {
        $queueGridLink = $this->url->getUrl('amasty_ccpa/consentQueue/index');

        $this->messageManager->addComplexNoticeMessage(
            'addConsentQueueAddNoticeMessage',
            [
                'referer' => $queueGridLink
            ]
        );
    }
}
