<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model;

use Amasty\Ccpa\Api\Data\ConsentQueueInterface;
use Amasty\Ccpa\Model\ResourceModel\ConsentQueue as ConsentQueueResource;
use Magento\Framework\Model\AbstractModel;

class ConsentQueue extends AbstractModel implements ConsentQueueInterface
{
    public const STATUS_PENDING = 0;

    public const STATUS_SUCCESS = 1;

    public const STATUS_FAIL = 2;

    public function _construct()
    {
        parent::_construct();

        $this->_init(ConsentQueueResource::class);
    }

    /**
     * @inheritdoc
     */
    public function getCustomerId()
    {
        return $this->_getData(ConsentQueueInterface::CUSTOMER_ID);
    }

    /**
     * @inheritdoc
     */
    public function setCustomerId($customerId)
    {
        $this->setData(ConsentQueueInterface::CUSTOMER_ID, $customerId);

        return $this;
    }

    /**
     * @inheritdoc
     */
    public function getStatus()
    {
        return $this->_getData(ConsentQueueInterface::STATUS);
    }

    /**
     * @inheritdoc
     */
    public function setStatus($status)
    {
        $this->setData(ConsentQueueInterface::STATUS, $status);

        return $this;
    }
}
