<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\Consent\DataProvider;

use Amasty\Ccpa\Api\Data\ConsentInterface;
use Amasty\Ccpa\Model\Consent\ConsentStore\ConsentStore;
use Amasty\Ccpa\Model\Source\ConsentLinkType;
use Amasty\Ccpa\Model\Source\LinkToPolicy;
use Magento\Cms\Helper\Page as CmsHelper;

class ConsentPrivacyLinkResolver
{
    /**
     * @var CmsHelper
     */
    private $cmsHelper;

    public function __construct(
        CmsHelper $cmsHelper
    ) {
        $this->cmsHelper = $cmsHelper;
    }

    /**
     * @param ConsentInterface $consent
     *
     * @return string
     */
    public function getPrivacyLink(ConsentInterface $consent)
    {
        $privacyLinkType = $consent->getPrivacyLinkType() ?: ConsentLinkType::PRIVACY_POLICY;

        switch ($privacyLinkType) {
            case ConsentLinkType::CMS_PAGE:
                return (string)$this->cmsHelper->getPageUrl($consent->_getData(ConsentStore::CMS_PAGE_ID));
            default:
                return LinkToPolicy::PRIVACY_POLICY;
        }
    }
}
