<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class GotFrom implements OptionSourceInterface
{
    public const AUTOMATIC = 'automatic';

    public const CUSTOMER_REQUEST = 'customer_request';

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['label' => __('Automatic Delete'), 'value' => self::AUTOMATIC],
            ['label' => __('Customer\'s Request'), 'value' => self::CUSTOMER_REQUEST]
        ];
    }
}
