<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class Action implements OptionSourceInterface
{
    public const DELETE_REQUEST_SUBMITTED = 'delete_request_submitted';
    public const DELETE_REQUEST_APPROVED = 'delete_request_approved';
    public const ALLOWED_TO_SELL_PERSONAL_INFORMATION = 'allowed_to_sell_personal_information';
    public const DENIED_TO_SELL_PERSONAL_INFORMATION = 'denied_to_sell_personal_information';

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'label' => __('Delete Request Submitted'),
                'value' => self::DELETE_REQUEST_SUBMITTED
            ],
            [
                'label' => __('Delete Request Approved'),
                'value' => self::DELETE_REQUEST_APPROVED
            ],
            [
                'label' => __('Allowed to Sell or Share Personal Information'),
                'value' => self::ALLOWED_TO_SELL_PERSONAL_INFORMATION
            ],
            [
                'label' => __('Denied to Sell or Share Personal Information'),
                'value' => self::DENIED_TO_SELL_PERSONAL_INFORMATION
            ]
        ];
    }
}
