<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Model;

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Customer\Model\Address;

class CalifornianDetector
{
    /**
     * @var CustomerRepositoryInterface
     */
    private $repository;

    public function __construct(
        CustomerRepositoryInterface $repository
    ) {
        $this->repository = $repository;
    }

    /**
     * @param int|CustomerInterface $customer
     * @return bool
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function isCalifornian($customer): bool
    {
        if (is_numeric($customer)) {
            $customer = $this->repository->getById($customer);
        }
        $isCalifornian = false;

        foreach ($customer->getAddresses() as $address) {
            if ($address->isDefaultBilling() && $address->getRegion()->getRegionCode() === 'CA') {
                $isCalifornian = true;
                break;
            }
        }

        return $isCalifornian;
    }
}
