<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Controller\Policy;

use Amasty\Ccpa\Api\PolicyRepositoryInterface;
use Amasty\Ccpa\Model\Config;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Cms\Model\Template\FilterProvider;

class PolicyText extends \Magento\Framework\App\Action\Action
{
    /**
     * @var PolicyRepositoryInterface
     */
    private $policyRepository;

    /**
     * @var Config
     */
    private $configProvider;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var FilterProvider
     */
    private $filterProvider;

    public function __construct(
        Context $context,
        FilterProvider $filterProvider,
        PolicyRepositoryInterface $policyRepository,
        Config $configProvider,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct($context);
        $this->filterProvider = $filterProvider;
        $this->policyRepository = $policyRepository;
        $this->configProvider = $configProvider;
        $this->storeManager = $storeManager;
    }

    public function execute()
    {
        $data = '';

        if ($this->configProvider->isModuleEnabled()) {
            $policy = $this->policyRepository->getCurrentPolicy(
                $this->storeManager->getStore()->getId()
            );

            if ($policy) {
                $data = $this->filterProvider->getPageFilter()->filter($policy->getContent());
            }

            return $this->resultFactory->create(ResultFactory::TYPE_RAW)->setContents($data);
        }

        return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)
            ->setUrl($this->_url->getUrl('no-route'));
    }
}
