<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Controller\Customer;

use Amasty\Ccpa\Model\CalifornianDetector;
use Amasty\Ccpa\Model\Config;
use Magento\Customer\Controller\AbstractAccount as AbstractAccountAction;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\NotFoundException;
use Magento\Store\Model\StoreManagerInterface;

class Settings extends AbstractAccountAction
{
    /**
     * @var Config
     */
    private $configProvider;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var CalifornianDetector
     */
    private $californianDetector;

    /**
     * @var Session
     */
    private $session;

    public function __construct(
        Context $context,
        Config $configProvider,
        StoreManagerInterface $storeManager,
        CalifornianDetector $californianDetector,
        Session $session
    ) {
        parent::__construct($context);
        $this->configProvider = $configProvider;
        $this->storeManager = $storeManager;
        $this->californianDetector = $californianDetector;
        $this->session = $session;
    }

    public function execute()
    {
        $customerId = $this->session->getCustomerId();
        $websiteId = $this->storeManager->getWebsite()->getId();

        if (!$this->configProvider->isModuleEnabled()
            || !$this->configProvider->isAnySectionVisible()
            || ($this->configProvider->isOnlyCalifornians($websiteId)
                && !$this->californianDetector->isCalifornian($customerId))
        ) {
            throw new NotFoundException(__('Invalid Request'));
        }

        return $this->resultFactory->create(ResultFactory::TYPE_PAGE);
    }
}
