<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Controller\Adminhtml\WithConsent;

use Amasty\Ccpa\Controller\Adminhtml\AbstractWithConsent;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Amasty\Ccpa\Model\ConsentQueue\Notification;

class Index extends AbstractWithConsent
{
    /**
     * @var Notification
     */
    private $notification;

    public function __construct(
        Context $context,
        Notification $notification
    ) {
        parent::__construct($context);
        $this->notification = $notification;
    }

    /**
     * Index action
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $this->notification->addQueueLinkNotice();
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $resultPage->setActiveMenu('Amasty_Ccpa::with_consent');
        $resultPage->getConfig()->getTitle()->prepend(__('Customers With Consent'));
        $resultPage->addBreadcrumb(__('Customers With Consent'), __('Customers With Consent'));

        return $resultPage;
    }
}
