<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Controller\Adminhtml\Consents;

use Amasty\Ccpa\Controller\Adminhtml\AbstractConsents;
use Amasty\Ccpa\Model\Consent\Repository;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;

class Edit extends AbstractConsents
{
    /**
     * @var Repository
     */
    private $repository;

    public function __construct(
        Context $context,
        Repository $repository
    ) {
        $this->repository = $repository;

        parent::__construct($context);
    }

    /**
     * @return Page|ResponseInterface|ResultInterface
     */
    public function execute()
    {
        /** @var Page $resultPage */
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $resultPage->setActiveMenu(self::ADMIN_RESOURCE);
        $consentId = (int)$this->getRequest()->getParam('id');

        if ($consentId) {
            try {
                $this->repository->getById($consentId);
                $resultPage->getConfig()->getTitle()->prepend(__('Edit Checkbox'));
                $resultPage->getLayout()->addBlock(
                    \Magento\Backend\Block\Store\Switcher::class,
                    'store_switcher',
                    'page.main.actions'
                );
            } catch (\Magento\Framework\Exception\NoSuchEntityException $exception) {
                $this->messageManager->addErrorMessage(__('This consent no longer exists...'));

                return $this->resultRedirectFactory->create()->setPath('*/*/index');
            }
        } else {
            $resultPage->getConfig()->getTitle()->prepend(__('New Checkbox'));
        }

        return $resultPage;
    }
}
