<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Controller\Adminhtml\ActionLog;

use Amasty\Ccpa\Controller\Adminhtml\AbstractActionLog;
use Magento\Framework\Controller\ResultFactory;

class Index extends AbstractActionLog
{
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $resultPage->setActiveMenu('Amasty_Ccpa::action_log');
        $resultPage->getConfig()->getTitle()->prepend(__('Action Log'));
        $resultPage->addBreadcrumb(__('Action Log'), __('Action Log'));

        return $resultPage;
    }
}
