<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Block\Widget;

use Amasty\Ccpa\Api\PolicyRepositoryInterface;
use Amasty\Ccpa\Model\Config;
use Magento\Cms\Model\Template\FilterProvider;
use Magento\Framework\View\Element\Template;

class Policy extends Template implements \Magento\Widget\Block\BlockInterface
{
    /**
     * @var string
     */
    protected $_template = 'widget/policycontent.phtml';

    /**
     * @var PolicyRepositoryInterface
     */
    private $policyRepository;

    /**
     * @var Config
     */
    private $configProvider;

    /**
     * @var FilterProvider
     */
    private $filterProvider;

    /**
     * Policy widget constructor.
     *
     * @param Template\Context          $context
     * @param PolicyRepositoryInterface $policyRepository
     * @param Config                    $configProvider
     * @param array                     $data
     */
    public function __construct(
        Template\Context $context,
        PolicyRepositoryInterface $policyRepository,
        Config $configProvider,
        FilterProvider $filterProvider,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->policyRepository = $policyRepository;
        $this->configProvider = $configProvider;
        $this->filterProvider = $filterProvider;
    }

    /**
     * @return string
     */
    public function getPolicyText()
    {
        if ($this->configProvider->isModuleEnabled()) {
            $policy = $this->policyRepository->getCurrentPolicy(
                $this->_storeManager->getStore()->getId()
            );

            if ($policy) {
                return $this->filterProvider->getPageFilter()->filter($policy->getContent());
            }
        }

        return '';
    }
}
