<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Block;

use Amasty\Ccpa\Model\ConsentLogger;
use Magento\Newsletter\Block\Subscribe as SubscribeBlock;
use Magento\Framework\Exception\LocalizedException;

class SubscribePlugin
{
    /**
     * @param SubscribeBlock $subject
     * @param                 $result
     *
     * @return string
     * @throws LocalizedException
     */
    public function afterToHtml(SubscribeBlock $subject, $result)
    {
        $layout = $subject->getLayout();

        if (!$layout->getBlock('form.subscribe')
            || $layout->getBlock('amasty_ccpa_newsletter')
        ) {
            return $result;
        }

        $checkboxBlock = $layout->createBlock(
            \Amasty\Ccpa\Block\Checkbox::class,
            'amasty_ccpa_newsletter',
            [
                'scope' => ConsentLogger::FROM_SUBSCRIPTION
            ]
        )->setTemplate('Amasty_Ccpa::checkbox.phtml')->toHtml();

        if ($checkboxBlock) {
            $pos = strripos($result, '</form>');
            $endOfHtml = substr($result, $pos);
            $result = substr_replace($result, $checkboxBlock, $pos) . $endOfHtml;
        }

        return $result;
    }
}
