<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Block;

use Magento\Framework\Exception\LocalizedException;
use Amasty\Ccpa\Model\ConsentLogger;

class SocialLoginPlugin
{
    /**
     * @param \Amasty\SocialLogin\Block\Popup $subject
     * @param                                 $result
     *
     * @return string
     * @throws LocalizedException
     */
    public function afterToHtml(\Amasty\SocialLogin\Block\Popup $subject, $result)
    {
        $layout = $subject->getLayout();

        if (!$layout->getBlock('social-login-popup')
            || $layout->getBlock('amasty_ccpa_social')
        ) {
            return $result;
        }

        $checkboxBlock = $layout->createBlock(
            Checkbox::class,
            'amasty_ccpa_social',
            [
                'scope' => ConsentLogger::FROM_REGISTRATION
            ]
        )->setTemplate('Amasty_Ccpa::checkbox.phtml')->toHtml();

        if ($checkboxBlock) {
            $fieldsetText = '</fieldset>';
            $pos = strripos($result, $fieldsetText);
            $result = substr_replace($result, $checkboxBlock . $fieldsetText, $pos, strlen($fieldsetText));
        }

        return $result;
    }
}
