<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Block;

use Amasty\Ccpa\Model\ConsentLogger;
use Magento\Contact\Block\ContactForm as ContactBlock;
use Magento\Framework\Exception\LocalizedException;

class ContactPlugin
{
    /**
     * @param ContactBlock $subject
     * @param               $result
     *
     * @return string
     * @throws LocalizedException
     */
    public function afterToHtml(ContactBlock $subject, $result)
    {
        $layout = $subject->getLayout();

        if (!$layout->getBlock('contactForm')
            || $layout->getBlock('amasty_ccpa_contact')
        ) {
            return $result;
        }

        $checkboxBlock = $layout->createBlock(
            \Amasty\Ccpa\Block\Checkbox::class,
            'amasty_ccpa_contact',
            [
                'scope' => ConsentLogger::FROM_CONTACTUS
            ]
        )->setTemplate('Amasty_Ccpa::checkbox.phtml')->toHtml();

        if ($checkboxBlock) {
            $fieldsetText = '</fieldset>';
            $pos = strripos($result, $fieldsetText);
            $result = substr_replace($result, $checkboxBlock . $fieldsetText, $pos, strlen($fieldsetText));
        }

        return $result;
    }
}
