<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Block;

use Amasty\Ccpa\Model\Consent;
use Amasty\Ccpa\Model\Consent\DataProvider\ConsentPrivacyLinkResolver;
use Amasty\Ccpa\Model\Consent\DataProvider\FrontendData;
use Amasty\Ccpa\Model\Consent\RegistryConstants;
use Amasty\Ccpa\Model\ConsentLogger;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\Template;

class Checkbox extends Template implements IdentityInterface
{
    /**
     * @var string
     */
    protected $_template = 'checkbox.phtml';

    /**
     * @var string
     */
    private $scope;

    /**
     * @var FrontendData
     */
    private $dataProvider;

    /**
     * @var ConsentPrivacyLinkResolver
     */
    private $consentPrivacyLinkResolver;

    public function __construct(
        Template\Context $context,
        FrontendData $dataProvider,
        ConsentPrivacyLinkResolver $consentPrivacyLinkResolver,
        $scope = ConsentLogger::FROM_REGISTRATION,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->dataProvider = $dataProvider;
        $this->consentPrivacyLinkResolver = $consentPrivacyLinkResolver;
        $this->scope = $scope;
    }

    /**
     * @return array
     * @throws NoSuchEntityException
     * @throws LocalizedException
     */
    public function getConsents()
    {
        return $this->dataProvider->getData($this->scope);
    }

    /**
     * @param Consent\Consent $consent
     *
     * @return string
     */
    public function getConsentText(Consent\Consent $consent)
    {
        return str_replace(
            RegistryConstants::LINK_PLACEHOLDER,
            $this->consentPrivacyLinkResolver->getPrivacyLink($consent),
            $consent->getConsentText()
        );
    }

    /**
     * @return array|string[]
     */
    public function getIdentities()
    {
        return [\Amasty\Ccpa\Model\WithConsent::CACHE_TAG];
    }

    /**
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * @return string
     */
    public function getConsentFromLocation()
    {
        return RegistryConstants::CONSENT_FROM;
    }

    /**
     * @return string
     */
    public function getUniqueKey()
    {
        return 'amprivacy-checkbox-' . uniqid();
    }
}
