<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Block;

use Magento\CheckoutAgreements\Block\Agreements as AgreementsBlock;
use Magento\Framework\Exception\LocalizedException;
use Amasty\Ccpa\Model\ConsentLogger;

class AgreementsPlugin
{
    /**
     * @param AgreementsBlock $subject
     * @param                 $result
     *
     * @return string
     * @throws LocalizedException
     */
    public function afterToHtml(AgreementsBlock $subject, $result)
    {
        $layout = $subject->getLayout();

        if (!$layout->getBlock('amasty.ccpa.privacy.policy.popup')
            || $layout->getBlock('amasty_ccpa_agreements')
        ) {
            return $result;
        }

        $checkboxBlock = $layout->createBlock(
            Checkbox::class,
            'amasty_ccpa_agreements',
            [
                'scope' => ConsentLogger::FROM_CHECKOUT
            ]
        );

        return $checkboxBlock->toHtml() . $result;
    }
}
