<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Block;

use Amasty\Ccpa\Model\CalifornianDetector;
use Amasty\Ccpa\Model\Config;
use Magento\Customer\Model\Session;
use Magento\Framework\View\Element\Html\Link\Current as M21LinkClass;
use Magento\Customer\Block\Account\SortLinkInterface as M22LinkClass;

class AccountLinkPlugin
{
    public const SORT_ORDER = 175;
    public const INSERT_AFTER = 'customer-account-navigation-account-edit-link';
    public const LINK_BLOCK_NAME = 'customer-account-amasty-ccpa-settings';
    public const LINK_BLOCK_ALIAS = 'amasty-ccpa-link';

    /**
     * @var Config
     */
    private $configProvider;

    /**
     * @var Session
     */
    private $customerSession;

    /**
     * @var CalifornianDetector
     */
    private $californianDetector;

    public function __construct(
        Config $configProvider,
        Session $customerSession,
        CalifornianDetector $californianDetector
    ) {
        $this->configProvider = $configProvider;
        $this->customerSession = $customerSession;
        $this->californianDetector = $californianDetector;
    }

    /**
     * Insert menu item depending on Magento version
     *
     * @param \Magento\Framework\View\Element\Html\Links|\Magento\Customer\Block\Account\Navigation $subject
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function beforeGetLinks($subject)
    {
        $customerId = (int)$this->customerSession->getId();

        if ($subject->getNameInLayout() != 'customer_account_navigation'
            || !$this->configProvider->isModuleEnabled()
            || ($this->configProvider->isOnlyCalifornians() && !$this->californianDetector->isCalifornian($customerId))
            || !$this->customerSession->isLoggedIn()
            || !$this->configProvider->isAnySectionVisible()
        ) {
            return;
        }

        $linkClass = interface_exists(M22LinkClass::class) ? M22LinkClass::class : M21LinkClass::class;

        if (!$subject->getLayout()->hasElement(self::LINK_BLOCK_NAME)) {
            $subject->getLayout()->createBlock(
                $linkClass,
                self::LINK_BLOCK_NAME,
                [
                    'data' => [
                        'path' => 'ccpa/customer/settings',
                        'label' => __('US Privacy Settings'),
                        'sortOrder' => self::SORT_ORDER
                    ]
                ]
            );
        }

        if (!$subject->getChildBlock(self::LINK_BLOCK_ALIAS)) {
            $subject->insert(
                $subject->getLayout()->getBlock(self::LINK_BLOCK_NAME),
                self::INSERT_AFTER,
                true,
                self::LINK_BLOCK_ALIAS
            );
        }
    }
}
