<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Api\Data;

interface ActionLogInterface
{
    /**#@+
     * Constants defined for keys of data array
     */
    public const ID = 'id';
    public const CUSTOMER_ID = 'customer_id';
    public const CREATED_AT = 'created_at';
    public const IP = 'ip';
    public const ACTION = 'action';
    /**#@-*/

    /**
     * @return int
     */
    public function getId();

    /**
     * @param int $id
     *
     * @return \Amasty\Ccpa\Api\Data\ActionLogInterface
     */
    public function setId($id);

    /**
     * @return int|null
     */
    public function getCustomerId();

    /**
     * @param int|null $customerId
     *
     * @return \Amasty\Ccpa\Api\Data\ActionLogInterface
     */
    public function setCustomerId($customerId);

    /**
     * @return string
     */
    public function getCreatedAt();

    /**
     * @param string $createdAt
     *
     * @return \Amasty\Ccpa\Api\Data\ActionLogInterface
     */
    public function setCreatedAt($createdAt);

    /**
     * @return string
     */
    public function getIp();

    /**
     * @param string $ip
     *
     * @return \Amasty\Ccpa\Api\Data\ActionLogInterface
     */
    public function setIp($ip);

    /**
     * @return string
     */
    public function getAction();

    /**
     * @param string $action
     *
     * @return \Amasty\Ccpa\Api\Data\ActionLogInterface
     */
    public function setAction($action);
}
