<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package California Consumer Privacy Act for Magento 2
 */

namespace Amasty\Ccpa\Api;

/**
 * @api
 */
interface ConsentQueueRepositoryInterface
{
    /**
     * Save
     *
     * @param \Amasty\Ccpa\Api\Data\ConsentQueueInterface $deleteRequest
     * @return \Amasty\Ccpa\Api\Data\ConsentQueueInterface
     */
    public function save(\Amasty\Ccpa\Api\Data\ConsentQueueInterface $deleteRequest);

    /**
     * Get by id
     *
     * @param int $id
     * @return \Amasty\Ccpa\Api\Data\ConsentQueueInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($id);

    /**
     * Delete
     *
     * @param \Amasty\Ccpa\Api\Data\ConsentQueueInterface $deleteRequest
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(\Amasty\Ccpa\Api\Data\ConsentQueueInterface $deleteRequest);

    /**
     * Delete by id
     *
     * @param int $id
     * @return bool true on success
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($id);

    /**
     * Lists
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Magento\Framework\Api\SearchResultsInterface
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $searchCriteria);
}
