<?php
declare(strict_types=1);

namespace Amasty\CashOnDelivery\Model;

use Amasty\CashOnDelivery\Api\TaxFeeDetailsInterface;
use Magento\Framework\DataObject;

class TaxFeeDetails extends DataObject implements TaxFeeDetailsInterface
{
    /**
     * @return float|null
     */
    public function getValueExclTax(): ?float
    {
        return $this->getData(TaxFeeDetailsInterface::VALUE_EXCL_TAX);
    }

    /**
     * @param float $amountExclTax
     * @return TaxFeeDetailsInterface
     */
    public function setValueExclTax(float $amountExclTax): TaxFeeDetailsInterface
    {
        return $this->setData(TaxFeeDetailsInterface::VALUE_EXCL_TAX, $amountExclTax);
    }

    /**
     * @return float|null
     */
    public function getValueInclTax(): ?float
    {
        return $this->getData(TaxFeeDetailsInterface::VALUE_INCL_TAX);
    }

    /**
     * @param float $amountInclTax
     * @return TaxFeeDetailsInterface
     */
    public function setValueInclTax(float $amountInclTax): TaxFeeDetailsInterface
    {
        return $this->setData(TaxFeeDetailsInterface::VALUE_INCL_TAX, $amountInclTax);
    }
}
