<?php
declare(strict_types=1);

namespace Amasty\CashOnDelivery\Model;

use Magento\Checkout\Model\ConfigProviderInterface;

class CheckoutConfigProvider implements ConfigProviderInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(ConfigProvider $configProvider)
    {
        $this->configProvider = $configProvider;
    }

    /**
     * @return array
     */
    public function getConfig(): array
    {
        $config = [];
        $config['amasty'] = [
            'cashOnDelivery' => [
                'paymentFeeType' => $this->configProvider->getPaymentFeeType(),
                'displayPriceMode' => $this->configProvider->getDisplayFeeAtCart()
            ]
        ];

        return $config;
    }
}
