<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Cancel Orders for Magento 2
 */

namespace Amasty\CancelOrder\Plugin\SalesRule\Model\Rule\Customer;

use Amasty\Base\Model\MagentoVersion;
use Magento\SalesRule\Model\Rule\Customer;

/**
 * This plugin fixes update of sales rules for customers, who used coupons.
 * Originally, magento does not check loaded customer link of sales rule and tries to save it, which causes fatal error
 *
 * Caused by @see \Magento\SalesRule\Model\Coupon\Usage\Processor::updateCustomerRuleUsages()
 */
class SaveEmptyCustomerRuleFix
{
    /**
     * @var \Amasty\Base\Model\MagentoVersion
     */
    private $magentoVersion;

    public function __construct(MagentoVersion $magentoVersion)
    {
        $this->magentoVersion = $magentoVersion;
    }

    public function aroundSave(Customer $subject, \Closure $proceed): void
    {
        if ($this->isPluginEligible($subject)) {
            return;
        }

        $proceed();
    }

    public function isPluginEligible(Customer $subject): bool
    {
        return version_compare($this->magentoVersion->get(), '2.4.5', '<') && !$subject->hasData();
    }
}
