<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Cancel Orders for Magento 2
 */

namespace Amasty\CancelOrder\Model\Source;

class Refund implements \Magento\Framework\Option\ArrayInterface
{
    public const ONLINE = 'online';
    public const OFFLINE = 'offline';
    public const DISABLED = 'disabled';

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => self::DISABLED,
                'label' => __('Disabled')
            ],
            [
                'value' => self::ONLINE,
                'label' => __('Online (if possible)')
            ],
            [
                'value' => self::OFFLINE,
                'label' => __('Offline')
            ]
        ];
    }
}
