<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Cancel Orders for Magento 2
 */

namespace Amasty\CancelOrder\Model\Source;

class Elements implements \Magento\Framework\Option\ArrayInterface
{
    public const COMMENT = 'comment';
    public const REASON = 'reason';

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => self::COMMENT,
                'label' => __('Comment')
            ],
            [
                'value' => self::REASON,
                'label' => __('Reason')
            ]
        ];
    }
}
