<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Cancel Orders for Magento 2
 */

namespace Amasty\CancelOrder\Model\Source\AutoCancelMode;

class OrderStatus implements \Magento\Framework\Option\ArrayInterface
{
    public const PENDING = 'pending';
    public const PENDING_PAYMENT = 'pending_payment';

    /**
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => self::PENDING,
                'label' => __('Pending')
            ],
            [
                'value' => self::PENDING_PAYMENT,
                'label' => __('Pending Payment')
            ]
        ];
    }
}
