<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Blog Pro Hyva Compatibility by Amasty
 */

declare(strict_types=1);

namespace Amasty\BlogHyva\Plugin;

use Amasty\Blog\Plugin\View\Page\Config\Renderer as AmastyRenderer;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\View\Page\Config\Renderer as MagentoRenderer;

class RemoveAmastyCssInAmBlogPlugin
{
    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @param CurrentTheme $currentTheme
     */
    public function __construct(CurrentTheme $currentTheme)
    {
        $this->currentTheme = $currentTheme;
    }

    /**
     * Remove amblogcss for Hyva theme only
     *
     * @param AmastyRenderer $subject
     * @param callable $proceed
     * @param MagentoRenderer $origSubject
     * @param array $resultGroups
     * @return array[]
     */
    public function aroundBeforeRenderAssets(
        AmastyRenderer  $subject,
        callable        $proceed,
        MagentoRenderer $origSubject,
        $resultGroups = []
    ): array {
        if ($this->currentTheme->isHyva()) {
            return [$resultGroups];
        }
        return $proceed($origSubject, $resultGroups);
    }
}
