<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Blog Pro Hyva Compatibility by Amasty
 */

declare(strict_types=1);

namespace Amasty\BlogHyva\Plugin;

use Amasty\Blog\Model\UrlResolver;
use Hyva\Theme\ViewModel\Navigation;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\ScopeInterface;

class AddBlogLinkToMenu
{
    /** @var UrlResolver  */
    private UrlResolver $urlResolver;

    /** @var ScopeConfigInterface  */
    private ScopeConfigInterface $scopeConfig;

    /**
     * Constructor.
     *
     * @param UrlResolver $urlResolver
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        UrlResolver $urlResolver,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->urlResolver = $urlResolver;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Add navigation link to the menu.
     *
     * @param Navigation $subject
     * @param array $result
     * @param bool|int $maxLevel
     * @return array
     * @throws NoSuchEntityException
     */
    public function afterGetNavigation(Navigation $subject, array $result, $maxLevel = false): array
    {
        if (!$this->isShowInNavMenuEnabled()) {
            return $result;
        }

        $result[] = [
            'name' => $this->getLinkLabel(),
            'url' => $this->urlResolver->getBlogUrl()
        ];

        return $result;
    }

    /**
     * Check if the blog link should be displayed in the menu.
     *
     * @return bool
     */
    private function isShowInNavMenuEnabled(): bool
    {
        return $this->scopeConfig->isSetFlag(
            'amblog/display_settings/display_at_category',
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get Label for the blog link.
     *
     * @return string
     */
    private function getLinkLabel(): string
    {
        return $this->scopeConfig->getValue(
            'amblog/display_settings/label',
            ScopeInterface::SCOPE_STORE
        );
    }
}
