<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Banner Slider Base for Magento 2
 */

namespace Amasty\BannerSlider\Plugin\Framework\App\Http;

use Amasty\BannerSlider\Model\MobileDetect;
use Magento\Framework\App\Http\Context as HttpContext;

class ContextPlugin
{
    public const IS_MOBILE_HTTP_CONTEXT_KEY  = 'IS_MOBILE_HTTP_CONTEXT_KEY';

    /**
     * @var MobileDetect
     */
    private $mobileDetect;

    public function __construct(
        MobileDetect $mobileDetect
    ) {
        $this->mobileDetect = $mobileDetect;
    }

    /**
     * @param HttpContext $subject
     */
    public function beforeGetVaryString(HttpContext $subject)
    {
        $subject->setValue(self::IS_MOBILE_HTTP_CONTEXT_KEY, (int)$this->mobileDetect->isMobile(), '');
    }
}
