<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Banner Slider Base for Magento 2
 */

namespace Amasty\BannerSlider\Model\Analytics\Command;

use Amasty\BannerSlider\Api\Data\AnalyticInterface;
use Amasty\BannerSlider\Model\Analytics\Analytic;
use Magento\Framework\Exception\CouldNotSaveException;

interface SaveAnalyticInterface
{
    /**
     * @param AnalyticInterface|Analytic $analytic
     * @return void
     * @throws CouldNotSaveException
     */
    public function execute(AnalyticInterface $analytic): void;
}
