<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Auto Add Promo Items Graphql by Amasty
 */

use Amasty\Promo\Api\Data\GiftRuleInterfaceFactory;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Framework\Registry;
use Magento\SalesRule\Model\Rule;
use Magento\Store\Model\StoreManagerInterface;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/Multishipping/Fixtures/simple_product_10.php');

$objectManager = Bootstrap::getObjectManager();
/** @var Registry $registry */
$registry = $objectManager->get(Registry::class);

/** @var GiftRuleInterfaceFactory $giftRuleFactory */
$giftRuleFactory = $objectManager->get(GiftRuleInterfaceFactory::class);

$giftRule = $giftRuleFactory->create()
    ->setSku('simple_10')
    ->setItemsDiscount("20")
    ->setMinimalItemsPrice("0")
    ->setApplyTax("0")
    ->setApplyShipping("1")
    ->setType('0');

/** @var Rule $salesRule */
$salesRule = $objectManager->create(Rule::class);
$salesRule->setData(
    [
        'name' => 'Graph Test Promo Rule Whole Cart',
        'is_active' => 1,
        'customer_group_ids' => [0,1],
        'extension_attributes' => [
            'ampromo_rule' => $giftRule
        ],
        'simple_action' => 'ampromo_cart',
        'discount_amount' => 3,
        'discount_step' => 0,
        'stop_rules_processing' => 0,
        'website_ids' => [Bootstrap::getObjectManager()->get(StoreManagerInterface::class)->getWebsite()->getId()
        ],
        'coupon_type' => Rule::COUPON_TYPE_NO_COUPON
    ]
);
$salesRule->save();
$registry->unregister('Amasty/PromoGraphql/Test/GraphQl/_files/promo_rule_whole_cart.php');
$registry->register('Amasty/PromoGraphql/Test/GraphQl/_files/promo_rule_whole_cart.php', $salesRule->getRuleId());
