<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Auto Add Promo Items Graphql by Amasty
 */

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\SalesRule\Api\RuleRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;

$bootstrap = Bootstrap::getObjectManager();

/** @var Registry $registry */
$registry = $bootstrap->get(Registry::class);

/** @var RuleRepositoryInterface $ruleRepository */
$ruleRepository = $bootstrap->get(RuleRepositoryInterface::class);

$ruleId = $registry->registry('Amasty/PromoGraphql/Test/GraphQl/_files/promo_rule_same.php');
if ($ruleId) {
    try {
        $ruleRepository->deleteById($ruleId);
        $registry->unregister('Amasty/PromoGraphql/Test/GraphQl/_files/promo_rule_same.php');
    } catch (NoSuchEntityException $e) {
    }
}
