<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Auto Add Promo Items Graphql by Amasty
 */

use Amasty\Promo\Api\Data\GiftRuleInterfaceFactory;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Framework\Registry;
use Magento\SalesRule\Model\Rule;
use Magento\Store\Model\StoreManagerInterface;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/Multishipping/Fixtures/virtual_product_5.php');

$objectManager = Bootstrap::getObjectManager();
/** @var Registry $registry */
$registry = $objectManager->get(Registry::class);

/** @var GiftRuleInterfaceFactory $giftRuleFactory */
$giftRuleFactory = $objectManager->get(GiftRuleInterfaceFactory::class);

$giftRule = $giftRuleFactory->create()
    ->setItemsDiscount("")
    ->setMinimalItemsPrice("")
    ->setApplyTax("0")
    ->setApplyShipping("1")
    ->setType('0');

/** @var Rule $salesRule */
$salesRule = $objectManager->create(Rule::class);
$salesRule->setData(
    [
        'name' => 'Graph Test Promo Rule Same',
        'is_active' => 1,
        'customer_group_ids' => [0,1],
        'extension_attributes' => [
            'ampromo_rule' => $giftRule
        ],
        'simple_action' => 'ampromo_product',
        'discount_amount' => 1,
        'discount_step' => 2,
        'stop_rules_processing' => 0,
        'website_ids' => [Bootstrap::getObjectManager()->get(StoreManagerInterface::class)->getWebsite()->getId()
        ],
        'coupon_type' => Rule::COUPON_TYPE_NO_COUPON,
    ]
);
$salesRule->save();
$registry->unregister('Amasty/PromoGraphql/Test/GraphQl/_files/promo_rule_same.php');
$registry->register('Amasty/PromoGraphql/Test/GraphQl/_files/promo_rule_same.php', $salesRule->getRuleId());
